<?php

namespace App\Modules\Booking\Application;

use App\Modules\Booking\Domain\AdminAbrv;
use App\Modules\Booking\Domain\BookingCode;
use App\Modules\Booking\Domain\BookingDate;
use App\Modules\Booking\Domain\BookingDateStart;
use App\Modules\Booking\Domain\BookingNoPax;
use App\Modules\Booking\Domain\BookingReferredFromName;
use App\Modules\Booking\Domain\BookingRelationshipName;
use App\Modules\Booking\Domain\BookingRepository;
use App\Modules\Booking\Domain\BookingStatus;
use App\Modules\Booking\Domain\ReportBooking;
use App\Modules\Booking\Domain\ReportBookingTour;
use App\Modules\Booking\Domain\ReportExcelRequirements;
use App\Modules\Booking\Domain\ReportInvoice;
use App\Modules\Booking\Domain\ReportPassenger;
use App\Modules\Booking\Domain\ReportUser;
use App\Modules\BookingTour\Domain\BookingTourDateStart;
use App\Modules\BookingTour\Domain\BookingTourName;
use App\Modules\BookingTour\Domain\BookingTourNoPax;
use App\Modules\BookingTour\Domain\BookingTourStatus;
use App\Modules\BookingTour\Domain\BookingTourTourDuration;
use App\Modules\BookingTour\Domain\BookingTourTourName;
use App\Modules\Invoice\Domain\InvoiceCode;
use App\Modules\Invoice\Domain\InvoiceTotal;
use App\Modules\Invoice\Domain\InvoiceTotalPay;
use App\Modules\Invoice\Domain\InvoiceTotalPending;
use App\Modules\Passenger\Domain\PassengerDOB;
use App\Modules\Passenger\Domain\PassengerEmail;
use App\Modules\Passenger\Domain\PassengerGender;
use App\Modules\Passenger\Domain\PassengerLastName;
use App\Modules\Passenger\Domain\PassengerName;
use App\Modules\Passenger\Domain\PassengerPhone;
use App\Modules\Passenger\Domain\PassengerStatus;
use App\Modules\User\Domain\UserEmail;
use App\Modules\User\Domain\UserLastName;
use App\Modules\User\Domain\UserName;
use App\Modules\User\Domain\UserPhone;
use App\Modules\User\Domain\UserPhoneCode;
use App\Modules\User\Domain\UserStatus;
use DateTime;

class BookingReporter
{

    private BookingRepository $repository;

    public function __construct(BookingRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke(ReportExcelRequirements $requirements)
    {
        $data = $this->repository->getReportExcel($requirements);
        
        $booking = array_map(fn($b) => new ReportBooking(
            new BookingCode($b->Booking_Code),
            new BookingDate(new DateTime($b->Booking_Date)),
            new BookingDateStart(new DateTime($b->Booking_DateStart)),
            new BookingNoPax($b->Booking_NoPax),
            new BookingStatus($b->Booking_Status),
            new BookingReferredFromName($b->BookingReferredFrom_Name),
            new BookingRelationshipName($b->BookingRelationship_Name),
            new AdminAbrv($b->Admin_Abrv ? $b->Admin_Abrv : ''),
            new ReportBookingTour(
                new BookingTourName($b->BookingTour_Name),
                new BookingTourTourName($b->BookingTour_TourName),
                new BookingTourNoPax($b->BookingTour_NoPax),
                new BookingTourDateStart(new DateTime($b->BookingTour_DateStart)),
                new BookingTourTourDuration($b->BookingTour_TourDuration),
                new BookingTourStatus($b->BookingTour_Status)
            ),
            new ReportPassenger(
                new PassengerName($b->Passenger_Name),
                new PassengerLastName($b->Passenger_LastName),
                new PassengerEmail($b->Passenger_Email),
                new PassengerPhone($b->Passenger_Phone),
                new PassengerStatus($b->BookingTourPassenger_Status),
                new PassengerDOB(new DateTime($b->Passenger_DOB)),
                new PassengerGender($b->Passenger_Gender),
            ),
            new ReportUser(
                new UserName($b->User_Name),
                new UserLastName($b->User_LastName),
                new UserEmail($b->User_Email),
                new UserPhone($b->User_Phone),
                new UserPhoneCode($b->User_PhoneCode),
                new UserStatus($b->User_Status)
            ),
            new ReportInvoice(
                new InvoiceCode($b->Invoice_Code),
                new InvoiceTotal($b->Invoice_Total),
                new InvoiceTotalPay($b->Invoice_TotalPay),
                new InvoiceTotalPending($b->Invoice_TotalPending)
            )
        ), $data);
        return $booking;
    }
}
