<?php

namespace App\Modules\Booking\Application;

use App\Modules\Booking\Domain\ReceiptBooking;
use App\Modules\Booking\Domain\BookingReceiptRepository;

class BookingReceiptChanger {

    private BookingReceiptRepository $repository;

    public function __construct(
        BookingReceiptRepository $repository
    ) {
        $this->repository = $repository;
    }

    public function __invoke(ReceiptBooking $model) {
        return $this->repository->changeReceipt($model);
    }
}