<?php

namespace App\Modules\Admin\Infrastructure;

use App\Modules\Admin\Domain\Admin;
use App\Modules\Admin\Domain\AdminRepository;
use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Admin\Domain\InsertAdmin;
use App\Modules\Admin\Domain\UpdateAdmin;
use App\Modules\Shared\Application\ActionHandler;
use App\Modules\Shared\Application\SelectHandler;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;

class MysqlAdminRepository implements AdminRepository
{

    public function find(string $action)
    {
        return Requester::requestSelect(
            'CALL sp_admin_list(?,@sts,@cod,@msg)',
            [
                $action
            ]
        );
    }

    public function index(IdAdmin $id)
    {
        return (new SelectHandler())->handle(DB::select(
            'CALL sp_admin_index(?)',
            [
                $id->value(),
            ]
        ));
    }

    public function insert(InsertAdmin $value)
    {
        return (new ActionHandler())->handle(DB::select(
            'CALL sp_admin_insert(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',
            [
                $value->name()->value(),
                $value->lastName()->value(),
                $value->abrv()->value(),
                $value->noDocument()->value(),
                $value->email()->value(),
                $value->emailAddress()->value(),
                $value->address()->value(),
                $value->phone()->value(),
                $value->color()->value(),
                $value->isAssignable()->value(),
                $value->imgProfile()->value(),
                $value->imgProfileThumb()->value(),
                $value->status()->value(),
                $value->idTypeDocument()->value(),
                $value->idAdminRole()->getValue(),
                $value->idCountry()->value(),
                $value->idState()->value(),
                $value->idCity()->value(),
            ]
        ));
    }

    public function update(UpdateAdmin $value)
    {
        return (new ActionHandler())->handle(DB::select(
            'CALL sp_admin_update(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)',
            [
                $value->id()->value(),
                $value->name()->value(),
                $value->lastName()->value(),
                $value->abrv()->value(),
                $value->noDocument()->value(),
                $value->email()->value(),
                $value->emailAddress()->value(),
                $value->address()->value(),
                $value->phone()->value(),
                $value->color()->value(),
                $value->isAssignable()->value(),
                $value->imgProfile()->value(),
                $value->imgProfileThumb()->value(),
                $value->status()->value(),
                $value->idTypeDocument()->value(),
                $value->idAdminRole()->getValue(),
                $value->idCountry()->value(),
                $value->idState()->value(),
                $value->idCity()->value(),
            ]
        ));
    }

    public function delete(IdAdmin $id)
    {
        return Requester::requestUpdate(
            'CALL sp_admin_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
