<?php

namespace App\Http;

use Illuminate\Foundation\Http\Kernel as HttpKernel;

class Kernel extends HttpKernel
{
    /**
     * The application's global HTTP middleware stack.
     *
     * These middleware are run during every request to your application.
     *
     * @var array<int, class-string|string>
     */
    protected $middleware = [
        \App\Http\Middleware\CorsMiddleware::class,
        // \Illuminate\Http\Middleware\HandleCors::class,
        \App\Http\Middleware\PreventRequestsDuringMaintenance::class,
        \App\Http\Middleware\TrimStrings::class,
    ];

    /**
     * The application's route middleware groups.
     *
     * @var array<string, array<int, class-string|string>>
     */
    protected $middlewareGroups = [
        'web' => [],
    ];

    /**
     * The application's route middleware.
     *
     * These middleware may be assigned to groups or used individually.
     *
     * @var array<string, class-string|string>
     */
    protected $routeMiddleware = [
        'Transaction' => \App\Http\Middleware\TransactionMiddleware::class,
        'Auth_Owner' => \App\Http\Middleware\Authenticate_Owner::class,
        'Auth_Owner_Url' => \App\Http\Middleware\Authenticate_Owner_Url::class,
        'Auth_Client' => \App\Http\Middleware\Authenticate_Client::class,
        'Auth_Passenger' => \App\Http\Middleware\Authenticate_Passenger::class,
        'Auth_ProviderReview' => \App\Http\Middleware\Authenticate_ProviderReview::class,
        'LockDomain' => \App\Http\Middleware\LockDomainMiddleware::class,
        // 'cache.headers' => \Illuminate\Http\Middleware\SetCacheHeaders::class,
    ];
}
