<?php

namespace App\Http\Controllers\Passenger;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Modules\Group\Application\GroupTokenFinder;
use App\Modules\Group\Domain\GroupToken;
use App\Modules\Group\Domain\IdGroup;
use App\Modules\Group\Infraestructure\MysqlGroupFindByTokenRepository;
use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\GroupProvider\Application\GroupProviderDocumentSearcher;
use App\Modules\GroupProvider\Infraestructure\MysqlGroupProviderRepository;
use App\Modules\Passenger\Application\PassengerSearchWithReview;
use App\Modules\Passenger\Domain\PassengerNoDocument;
use App\Modules\Passenger\Domain\PassengerReviewRange;
use App\Modules\Passenger\Infraestructure\MysqlPassengerSearchWithReviewRepository;
use App\Modules\PassengerReview\Application\PassengerReviewFinderByGroup;
use App\Modules\PassengerReview\Application\PassengerReviewFinderByGroupPassenger;
use App\Modules\PassengerReview\Infraestructure\MysqlPassengerReviewRepository;
use App\Modules\PassengerReview\Infraestructure\PassengerReviewValidators;
use App\Modules\Provider\Domain\ProviderNoDocument;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Domain\QueryList\ListInput;
use App\Modules\Shared\Exceptions\InvalidRequestException;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Support\Facades\DB;

class PassengerReview extends Controller
{
    private $oDomain;

    public function __construct()
    {
        $this->oDomain = "Passenger Review";
    }

    public function update(Request $Request)
    {
        $oReview        = array();
        $oResponse      = array();
        $oValParams     = array('PassengerReview' => 'required|string');


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oReview    = json_decode($Request->input("PassengerReview"));

            for ($k = 0; $k < count($oReview); $k++) {
                $oParam     = array(
                    $oReview[$k]->Id_PassengerReview,
                    $oReview[$k]->PassengerReview_Score,
                    $oReview[$k]->PassengerReview_Comment,
                    $oReview[$k]->PassengerReview_Values
                );

                $oData  = DB::select('call sp_client_passenger_review_update(?,?,?,?)', $oParam);
            }

            //  RESPONSE

            if ($oData[0]->Response_Success == 1) {
            } else {
            }

            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function list(Request $Request)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Token($Request->header("Token"), $this->oDomain);
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array($Request->header("Token"));
            $oData  = DB::select('call sp_client_passenger_review_list(?)', $oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain . " List";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function listByGroupToken(Request $Request)
    {
        (new LaravelValidator)->validate(
            $Request->all(),
            $this->oDomain,
            PassengerReviewValidators::GROUP_TOKEN_LIST
        );

        $tokenFinder = new GroupTokenFinder(new MysqlGroupFindByTokenRepository);
        $passengerReviewFinder = new PassengerReviewFinderByGroup(new MysqlPassengerReviewRepository);
        $groupProviderFinder = new GroupProviderDocumentSearcher(new MysqlGroupProviderRepository);

        $response = $tokenFinder(new GroupToken($Request->input('Group_Token')));
        $idGroup = new IdGroup($response[0]->Response_Id);
        $data = [
            'Permissions' => [],
            'Provider' => null,
            'PassengerReview' => [],
            'Passenger' => []
        ];
        $document = trim($Request->input('Passenger_NoDocument'));
        try {
            $response = $passengerReviewFinder(
                $idGroup,
                new PassengerNoDocument($document)
            );
            $data['Permissions'][] = 'PassengerReview';
            $data['PassengerReview'] = $response['Response_Data'];
        } catch (InvalidRequestException $th) {
            $data['Permissions'][] = 'Provider';
            try {
                $response = $groupProviderFinder($idGroup)(
                    new ProviderNoDocument($document)
                );
                $data['Provider'] = count($response['Response_Data']) ? $response['Response_Data'][0] : null;

                $listInput = new ListInput(1, 1000, '');

                $data['Passenger'] = (new PassengerSearchWithReview(new MysqlPassengerSearchWithReviewRepository))
                    ->__invoke(
                        new DateStart(date('Y-m-d')),
                        new DateEnd(date('Y-m-d')),
                        PassengerReviewRange::NODATE,
                        $idGroup->value(),
                        'all',
                        $listInput,
                        1
                    )['Response_Data'];
            } catch (InvalidRequestException $th2) {
                throw $th;
            }
        }

        $oResponse = $response;
        $oResponse["Response_Data"] = $data;
        return ResponseBuilder::Response($oResponse);
    }

    public function listByIdGroupPassenger(Request $Request)
    {
        (new LaravelValidator)->validate(
            $Request->all(),
            $this->oDomain,
            PassengerReviewValidators::GROUP_PASSENGER
        );

        $response = (new PassengerReviewFinderByGroupPassenger(new MysqlPassengerReviewRepository))
            ->__invoke(
                new IdGroupPassenger($Request->input('Id_GroupPassenger'))
            );

        return ResponseBuilder::Response($response);
    }
}
