<?php

namespace App\Http\Controllers\Passenger\GroupProviderReview;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Infraestructure\Requester;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class GroupProviderReviewUpdateAllController
{
    private $oDomain = 'GroupProviderReview';
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($idGroupProvider, Request $request)
    {
        (new LaravelValidator())->validate($request->all(), '', ['GroupProviderReview' => 'required|string']);
        $groupProvider = $this->getGroupProvider($idGroupProvider);

        if (!count($groupProvider)) {
            return $this->responseError(404, 404, 'Group provider not found');
        }
        if ($this->isAnswered($groupProvider)) {
            return $this->errorIsAnswered();
        }

        $review = json_decode($request->input("GroupProviderReview"));
        $this->answerAllGroupProviderReviews($review);
        $data = $this->answerGroupProvider($groupProvider);

        $oResponse = [];
        $oResponse["Response_Status"]           = 200;
        $oResponse["Response_Code"]             = 200;
        $oResponse["Response_Domain"]           = $this->oDomain;
        $oResponse["Response_Message"]          = 'Review respondido correctamente';
        $oResponse["Response_Data"]             = $data;
        $oResponse["Response_Error_Message"]    = '';
        $oResponse["Response_Error_Reason"]     = '';

        return ResponseBuilder::Response($oResponse);
    }

    private function answerAllGroupProviderReviews($reviewList)
    {
        foreach ($reviewList as $review) {
            $oParam = [
                $review->Id_GroupProviderReview,
                $review->GroupProviderReview_Score,
                $review->GroupProviderReview_Comment,
                $review->GroupProviderReview_Values
            ];

            Requester::requestUpdate(
                'call sp_group_provider_review_answer(?,?,?,?,@sts,@cod,@msg)',
                $oParam
            );
        }
    }

    private function answerGroupProvider($groupProvider)
    {
        $oParam = [
            $groupProvider[0]->Id_GroupProvider
        ];

        Requester::requestUpdate(
            'call sp_group_provider_answer(?,@sts,@cod,@msg)',
            $oParam
        );
    }

    private function errorIsAnswered()
    {
        return $this->responseError(400, 400, 'Group provider is currently answered');
    }

    private function isAnswered($groupProvider)
    {
        return $groupProvider[0]->GroupProvider_AnsweredReview == 2;
    }

    private function responseError($status, $code, $message)
    {
        $response = [
            "Response_Status"           => $status,
            "Response_Code"             => $code,
            "Response_Domain"           => $this->oDomain,
            "Response_Message"          => $message,
            "Response_Data"             => null,
            "Response_Error_Message"    => $message,
            "Response_Error_Reason"     => $message
        ];

        return ResponseBuilder::Response($response);
    }

    private function getGroupProvider($idGroupProvider)
    {
        return DB::select(
            'CALL sp_group_provider_index(?)',
            [$idGroupProvider]
        );
    }
}
