<?php

namespace App\Http\Controllers\Owner\WebContactMessageDetail;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\WebContactMessageDetail\Application\List\ListWebContactMessageDetailQuery;
use App\Modules\WebContactMessageDetail\Application\List\ListWebContactMessageDetailQueryResponse;

class WebContactMessageDetailListController extends Controller
{
    private $domain = 'WebContactMessageDetail';
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id_WebContact, $Action, Request $Request)
    {
        /** @var ListWebContactMessageDetailQueryResponse $response */
        $response = $this->queryBus->ask(new ListWebContactMessageDetailQuery($Id_WebContact, $Action));
        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->response(), '', $this->domain));
    }
}
