<?php

namespace App\Http\Controllers\Owner\Tour;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\Tour\Application\Update\TourUpdaterQuery;
use App\Modules\Tour\Application\Update\TourUpdaterResponse;
use App\Modules\Tour\Infraestructure\TourValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use Illuminate\Support\Str;

class TourUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "Tour";
        $this->history = new HistoryData(HistoryTables::TOUR);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, TourValidators::UPDATE);

        $this->history->obtainOld($request->input("Id_Tour"));

        /** @var TourUpdaterResponse $response */
        $response = $this->queryBus->ask(new TourUpdaterQuery(
            $request->input("Id_Tour"),
            trim(Str::upper($request->input("Tour_Code"))),
            trim($request->input("Tour_Name")),
            $request->input("Tour_UrlThumbnail"),
            $request->input("Tour_Duration"),
            $request->input("Tour_MinPax"),
            $request->input("Tour_Availability"),
            $request->input("Tour_AvailabilityStatus"),
            $request->input("Tour_Anticipation"),
            $request->input("Tour_AnticipationType"),
            $request->input("Tour_Color"),
            $request->input("Tour_Status"),
            $request->input("Id_CategoryTour"),
            $request->input("Id_TypeTour"),
            $request->input("Id_Country"),
            $request->input("Id_State"),
            $request->input("Id_City")
        ));

        $this->history->updateBasic($request->input("Id_Tour"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
