<?php

namespace App\Http\Controllers\Owner\StatusGroupProvider;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\StatusGroupProvider\Application\List\ListStatusGroupProviderQuery;
use App\Modules\StatusGroupProvider\Application\List\ListStatusGroupProviderQueryResponse;

class StatusGroupProviderListController extends Controller
{
    private $domain = 'StatusGroupProvider';
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Action, Request $Request)
    {
        /** @var ListStatusGroupProviderQueryResponse $response */
        $response = $this->queryBus->ask(new ListStatusGroupProviderQuery($Action));
        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->response(), '', $this->domain));
    }
}
