<?php

namespace App\Http\Controllers\Owner\QuestionTypeProvider;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\QuestionTypeProvider\Application\Delete\QuestionTypeProviderDeleterQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class QuestionTypeProviderDeleteController extends Controller
{
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->history = new HistoryData(HistoryTables::QUESTION_TYPE_PROVIDER);
    }

    public function __invoke(Request $request, $Id)
    {
        $this->history->obtainOld($Id);
        /** @var QuestionTypeProviderDeleterResponse $response */
        $response = $this->queryBus->ask(new QuestionTypeProviderDeleterQuery($Id));

        $this->history->deleteBasic($Id, $request);

        return ResponseBuilder::Response($response->response());
    }
}
