<?php

namespace App\Http\Controllers\Owner\Passenger;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Passenger\Application\Enable\EnablePassengerQuery;
use App\Modules\Passenger\Application\Enable\EnablePassengerResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use Illuminate\Http\Request;

class PassengerEnableController
{
    private HistoryData $history;
    
    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->history = new HistoryData(HistoryTables::passenger);
    }

    public function __invoke($IdPassenger, Request $request)
    {
        $this->history->obtainOld($IdPassenger);

        /** @var EnablePassengerResponse $response */
        $response = $this->queryBus->ask(new EnablePassengerQuery($IdPassenger));

        $this->history->updateBasic($IdPassenger, $request);
        return ResponseBuilder::Response($response->response());
    }
}
