<?php
namespace App\Http\Controllers\Owner\ModuleNotification;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\ModuleNotification\Application\ModuleNotificationFinder;
use App\Modules\ModuleNotification\Infraestructure\MysqlModuleNotificationRepository;
use App\Modules\Shared\Domain\QueryList\ListInput;
use Illuminate\Http\Request;

final class Find extends Controller
{
    private $oDomain;

    public function __construct()
    {
        $this->oDomain = 'ModuleNotification';
    }

    public function __invoke(Request $request, string $action)
    {
        $list = new ListInput(
            $request->input('page', '1'),
            $request->input('pageLength', '20'),
            ''
        );
        $response = (new ModuleNotificationFinder(new MysqlModuleNotificationRepository))
            ->__invoke($action, $list->getLimit(), $list->getOffset());
        return ResponseBuilder::Response($response);
    }
}
