<?php
namespace App\Http\Controllers\Owner\LeadPassenger;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\LeadPassenger\Application\List\LeadPassengerListerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadPassengerListController extends Controller
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id_Booking, $Action)
    {
        /** @var LeadPassengerListerResponse $response */
        $response = $this->queryBus->ask(new LeadPassengerListerQuery($Id_Booking, $Action));

        return ResponseBuilder::Response($response->response());
    }
}
