<?php
namespace App\Http\Controllers\Owner\LeadBookingTour;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\LeadBookingTour\Application\List\LeadBookingTourListerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingTourListController extends Controller
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id_LeadBooking, $Action)
    {
        /** @var LeadBookingTourListerResponse $response */
        $response = $this->queryBus->ask(new LeadBookingTourListerQuery($Id_LeadBooking, $Action));

        return ResponseBuilder::Response($response->response());
    }
}
