<?php

namespace App\Http\Controllers\Owner\LeadBooking;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\LeadBooking\Application\Update\LeadBookingUpdaterQuery;
use App\Modules\LeadBooking\Application\Update\LeadBookingUpdaterResponse;
use App\Modules\LeadBooking\Infraestructure\LeadBookingValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "LeadBooking";
        $this->history = new HistoryData(HistoryTables::LEAD_BOOKING);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, LeadBookingValidators::UPDATE);

        $this->history->obtainOld($request->input("Id_LeadBooking"));

        /** @var LeadBookingUpdaterResponse $response */
        $response = $this->queryBus->ask(new LeadBookingUpdaterQuery(
            $request->input('Id_LeadBooking'),
            $request->input('LeadBooking_Observation'),
            $request->input('LeadBooking_Contact'),
            $request->input('LeadBooking_CancellationReason'),
            $request->input('LeadBooking_CancellationRemark'),
            $request->input('LeadBooking_Status'),
            $request->input('Id_Admin'),
            $request->input('Id_GuideLanguage'),
            $request->input('Id_Language'),
            $request->input('Id_Lead'),
        ));

        $this->history->updateBasic($request->input("Id_LeadBooking"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
