<?php

namespace App\Http\Controllers\Owner\LeadBooking;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Lead\Application\Create\LeadInserterResponse;
use App\Modules\Lead\Application\CreateOrUpdate\LeadInsertOrUpdaterQuery;
use App\Modules\Lead\Application\CreateOrUpdate\LeadInsertOrUpdaterResponse;
use App\Modules\LeadBooking\Application\Create\LeadBookingInserterQuery;
use App\Modules\LeadBooking\Application\Create\LeadBookingInserterResponse;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\LeadBooking\Infraestructure\LeadBookingValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadBookingInsertController extends Controller
{
    private $domain;
    private HistoryData $history;
    private HistoryData $historyLead;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "LeadBooking";
        $this->history = new HistoryData(HistoryTables::LEAD_BOOKING);
        $this->historyLead = new HistoryData(HistoryTables::LEAD);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, LeadBookingValidators::INSERT);

        /** @var LeadInsertOrUpdaterResponse $leadResponse */
        $leadResponse = $this->queryBus->ask(new LeadInsertOrUpdaterQuery(
            $request->input('Id_Lead'),
            $request->input('Lead_Name'),
            $request->input('Lead_LastName'),
            $request->input('Lead_Email'),
            $request->input('Lead_PhoneCode'),
            $request->input('Lead_Phone'),
            $request->input('Id_TypeDocument') ?? 1,
            $request->input('Id_UserCountry'),
        ));
        $this->historyLead->insertBasic($request, $leadResponse->idLead()->value());

        /** @var LeadBookingInserterResponse $response */
        $response = $this->queryBus->ask(new LeadBookingInserterQuery(
            $request->input('LeadBooking_Observation'),
            $request->input('LeadBooking_Contact'),
            $request->input('LeadBooking_Status'),
            $request->input('Id_GuideLanguage'),
            $request->input('Id_Language'),
            $leadResponse->idLead()->value(),
            $request->header('Token'),
        ));
        $this->history->insertBasic($request, $response->response()['Response_Data']['Id']);

        return ResponseBuilder::Response($response->response());
    }
}
