<?php
namespace App\Http\Controllers\Owner\Lead;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Lead\Application\Delete\LeadDeleterQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadDeleteController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "Lead";
        $this->history = new HistoryData(HistoryTables::LEAD);
    }

    public function __invoke(Request $request, $Id)
    {
        $this->history->obtainOld($Id);
        /** @var LeadDeleterResponse $response */
        $response = $this->queryBus->ask(new LeadDeleterQuery($Id));

        $this->history->deleteBasic($Id, $request);

        return ResponseBuilder::Response($response->response());
    }
}
