<?php

namespace App\Http\Controllers\Owner\Info;

use App\Modules\BookingTourPassenger\Domain\BookingTourPassenger;
use App\Modules\HtlCampBooking\Application\ReloadAmount\ReloadAmountHtlCampBookingQuery;
use App\Modules\HtlCampBookingPassenger\Domain\HtlCampBookingPassengerStatus;
use App\Modules\HtlCampSchedule\Application\ReloadAmount\ReloadAmountHtlCampScheduleQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use Illuminate\Support\Facades\DB;

class Migration84Controller
{
    private $htlCampBooking = [];
    private $htlCampSchedule = [];
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    private function getLockedHtlCampBookingPassenger($offset, $limit)
    {
        return DB::select("SELECT
                `hcbp`.Id_HtlCampBookingPassenger,
                `hcbp`.HtlCampBookingPassenger_Status,
                `hcb`.Id_HtlCampBooking,
                `btp`.Id_BookingTourPassenger,
                `btp`.BookingTourPassenger_Status,
                `btp`.BookingTourPassenger_PaymentStatus,
                `p`.Id_Passenger,
                `p`.Passenger_Status,
                `p`.Passenger_PaymentStatus,
                `p`.Passenger_InfoStatus,
                `p`.Passenger_CheckedInStatus,
                `b`.`Id_Booking`,
                `b`.`Booking_Status`,
                `b`.`Booking_ManuallyConfirmed`
            FROM t_htl_camp_booking_passenger `hcbp`
            INNER JOIN `t_htl_camp_booking` `hcb` ON `hcb`.`Id_HtlCampBooking` = `hcbp`.`Id_HtlCampBooking`
            INNER JOIN `t_booking_tour_passenger` `btp` ON `btp`.`Id_BookingTourPassenger` = `hcbp`.`Id_BookingTourPassenger`
            INNER JOIN `t_passenger` `p` ON `p`.`Id_Passenger` = `btp`.`Id_Passenger`
            INNER JOIN `t_booking` `b` ON `b`.`Id_Booking` = `p`.`Id_Booking`
            WHERE `HtlCampBooking_Lock` = 2
            ORDER BY `hcbp`.`Id_HtlCampBookingPassenger`
            LIMIT $offset, $limit");
    }

    private function getHtlCampBookings()
    {
        return DB::select('SELECT *
            FROM t_htl_camp_booking
            WHERE `HtlCampBooking_Lock` = 2');
    }

    private function getHtlCampSchedules()
    {
        return DB::select('SELECT * FROM t_htl_camp_schedule');
    }

    public function __invoke()
    {
        // $changed = array_merge([], $this->updatePassengers(0, 10000));
        // $changed = array_merge($changed, $this->updatePassengers(10000, 10000));
        // $changed = array_merge($changed, $this->updatePassengers(20000, 10000));
        // $changed = array_merge($changed, $this->updatePassengers(30000, 10000));
        // $changed = array_merge($changed, $this->updatePassengers(40000, 10000));
        // $changed = array_merge($changed, $this->updatePassengers(50000, 10000));
        // $changed = array_merge($changed, $this->updatePassengers(60000, 10000));
        // $changed = array_merge($changed, $this->updatePassengers(70000, 10000));
        // $changed = array_merge($changed, $this->updatePassengers(80000, 10000));

        $campBookings = $this->getHtlCampBookings();
        foreach ($campBookings as $htlCampBooking) {
            $this->queryBus->ask(new ReloadAmountHtlCampBookingQuery($htlCampBooking->Id_HtlCampBooking));
        }

        // $campSchedules = $this->getHtlCampSchedules();
        // foreach ($campSchedules as $htlCampSchedule) {
        //     $this->queryBus->ask(new ReloadAmountHtlCampScheduleQuery($htlCampSchedule->Id_HtlCampSchedule));
        // }
        // dd($campSchedules);
    }

    private function getHtlCampBookingFrom($changed)
    {
        foreach ($changed as $hcb) {
            if (!isset($this->htlCampBooking[$hcb->Id_HtlCampBooking])) {
                $this->htlCampBooking[$hcb->Id_HtlCampBooking] = $hcb;
            }
        }
        return array_values($this->htlCampBooking);
    }

    private function updatePassengers($offset, $limit)
    {
        $passengers = $this->getLockedHtlCampBookingPassenger($offset, $limit);
        $changed = [];
        foreach ($passengers as $htlCampBookingPassenger) {
            $hasChanged = $this->updateHtlCampBookingPassenger($htlCampBookingPassenger);
            if ($hasChanged) {
                $changed[] = $htlCampBookingPassenger;
            }
        }
        return $changed;
    }

    private function updateHtlCampBookingPassenger($htlCampBookingPassenger)
    {
        $isInCalendar = BookingTourPassenger::isInCalendar($htlCampBookingPassenger, $htlCampBookingPassenger);
        $isPending = BookingTourPassenger::isPending($htlCampBookingPassenger, $htlCampBookingPassenger);
        $status = $isInCalendar ? HtlCampBookingPassengerStatus::ACTIVE : ($isPending ? HtlCampBookingPassengerStatus::INACTIVE : HtlCampBookingPassengerStatus::DELETED);
        if ($htlCampBookingPassenger->HtlCampBookingPassenger_Status != $status) {
            $htlCampBookingPassenger->nextStatus = $status;
            $query = 'UPDATE `t_htl_camp_booking_passenger`
                SET `HtlCampBookingPassenger_Status` = ?
                WHERE `Id_HtlCampBookingPassenger` = ?';
            $value = [
                $status,
                $htlCampBookingPassenger->Id_HtlCampBookingPassenger,
            ];
            DB::update($query, $value);
            return true;
        }
        return false;
    }
}
