<?php

namespace App\Http\Controllers\Owner\Info;

use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\PHPMailer;

class MailSendController
{
    private function getIpAddress()
    {
        if (isset($_SERVER['HTTP_CLIENT_IP'])) {
            return $_SERVER['HTTP_CLIENT_IP'];
        } elseif (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            return $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else {
            return $_SERVER['REMOTE_ADDR'];
        }
    }

    public function __invoke()
    {
        $cip = $this->getIpAddress();
        $iptolocation = "http://www.geoplugin.net/json.gp?ip=" . $cip;
        $client_location = @json_decode(file_get_contents($iptolocation));
        $html_top = '<!DOCTYPE html><html lang="en"><head><meta charset="UTF-8"><meta name="viewport" content="width=device-width,initial-scale=1"><title>Salkantay Trekking -Booking Form</title><style>@import url(https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700;900;&display=swap);</style><style>*{box-sizing:border-box;padding:0;margin:0}html{background-color:#f0f0f0}body{font-size:15px;line-height:1.5;color:#555;color:#333}table{font-size:14px}.header{background-color:#333;padding:20px 10px 30px;font-weight:700;color:#fff}h1{font-size:30px;text-transform:uppercase;font-weight:900}.main-logo{width:120px;height:auto}strong{font-weight:700;text-transform:uppercase;font-size:12px;display:block;color:#f60;margin-bottom:5px;font-family:Montserrat,sans-serif}h1,h2{font-family:Montserrat,sans-serif}</style></head><body>';
        $html_bottom = '</body></html>';

        $data = [
            'trip_name' => 'Trip Name',
            'departure_date' => 'Departure Date',
            'n_adults' => 'N Adults',
            'n_children' => 'N Children',
            'message' => 'Mensaje de prueba',
            'first_name' => 'First Name',
            'last_name' => 'Last Name',
            'phone' => 'Phone',
            'country' => 'Country',
            'email' => 'jesuscuri13@gmail.com',
        ];

        $message_body = '<table
  class="main"
  style="
    font-family: Open Sans, Montserrat, Verdana, Geneva, Tahoma, sans-serif;
    width: 100%;background-color:#f8f8f8
  "
>
  <tr>
    <td style="background-color:#f8f8f8">
      <div
        class="container"
        style="
          width: 100%;
          margin-left: auto;
          margin-right: auto;
          max-width: 600px;
          background-color: white;
        "
      >
        <table class="header" width="100%">
          <tr>
            <td style="vertical-align: middle">
              <h1
                style="
                  font-size: 30px;
                  text-transform: uppercase;
                  font-weight: 900;
                "
              >
                Booking Form
              </h1>
            </td>
            <td align="right" style="text-align: right">
              <img
                class="main-logo"
                src="https://www.salkantaytrekking.com/assets/logo/salkantay-trekking-logo-white-400x150.png"
                alt="Salkantay Trekking"
              />
            </td>
          </tr>
        </table>
        <table class="article" width="100%">
          <tr>
            <td style="padding: 5px">
              <table width="100%">
                <tr class="information-block">
                  <td>
                    <table style="width: 100%">
                      <tr>
                        <td colspan="2" style="padding: 10px 0px 20px">
                          <h2
                            style="
                              font-size: 18px;
                              color: #fff;
                              background-color: #f60;
                              font-weight: 900;
                              border-radius: 3px;
                              padding: 5px 10px;
                              display: inline-block;
                            "
                          >
                            Trip Details
                          </h2>
                        </td>
                      </tr>
                      <tr>
                        <td colspan="2" style="padding: 5px">
                          <div
                            style="padding: 5px; background-color: #f8f8f8"
                          >
                            <strong>Adventure: </strong>' . $data['trip_name'] . '
                          </div>
                        </td>
                      </tr>
                      <tr>
                        <td colspan="2" style="padding: 5px">
                          <div
                            style="padding: 5px; background-color: #f8f8f8"
                          >
                            <strong>Departure Date (yyyy-mm-dd): </strong>' . $data['departure_date'] . '
                          </div>
                        </td>
                      </tr>
                      <tr>
                        <td style="padding: 5px" width="50%">
                          <div
                            style="background-color: #f8f8f8; padding: 5px"
                          >
                            <strong>Adults: </strong>' . $data['n_adults'] . '
                          </div>
                        </td>
                        <td style="padding: 5px" width="50%">
                          <div
                            style="background-color: #f8f8f8; padding: 5px"
                          >
                            <strong>Children: </strong>' . $data['n_children'] . '
                          </div>
                        </td>
                      </tr>
                      <tr>
                        <td colspan="2" style="padding: 5px">
                          <div
                            style="background-color: #f8f8f8; padding: 5px"
                          >
                            <strong>Message: </strong>' . $data['message'] . '
                          </div>
                        </td>
                      </tr>
                    </table>
                  </td>
                </tr>
                <tr class="information-block">
                  <td>
                    <table style="width: 100%">
                      <tr>
                        <td colspan="2" style="padding: 20px 0px 20px">
                          <h2
                            style="
                              font-size: 18px;
                              color: #fff;
                              background-color: #f60;
                              font-weight: 900;
                              border-radius: 3px;
                              padding: 5px 10px;
                              display: inline-block;
                            "
                          >
                            Contact Information
                          </h2>
                        </td>
                      </tr>

                      <tr>
                        <td style="padding: 5px" width="50%">
                          <div
                            style="background-color: #f8f8f8; padding: 5px"
                          >
                          <strong>First Name: </strong>' . $data['first_name'] . '
                          </div>
                        </td>
                        <td style="padding: 5px" width="50%">
                          <div
                            style="background-color: #f8f8f8; padding: 5px"
                          >
                          <strong>Last Name: </strong>' . $data['last_name'] . '
                          </div>
                        </td>
                      </tr>

                      <tr>
                        <td style="padding: 5px" width="50%">
                          <div
                            style="padding: 5px; background-color: #f8f8f8"
                          >
                            <strong>Phone Number: </strong>' . $data['phone'] . '
                          </div>
                        </td>
                        <td style="padding: 5px" width="50%">
                          <div
                            style="background-color: #f8f8f8; padding: 5px"
                          >
                            <strong>Country: </strong>' . $data['country'] . '
                          </div>
                        </td>
                      </tr>
                      <tr>
                        <td colspan="2" style="padding: 5px">
                          <div
                            style="padding: 5px; background-color: #f8f8f8"
                          >
                            <strong>Email Address: </strong
                            >' . $data['email'] . '
                          </div>
                        </td>
                      </tr>
                    </table>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        </table>
        <table
          class="footer"
          style="
            color: white;
            background-color: #333;
            width: 100%;
            padding: 10px 20px;
          "
        >
          <tr>
            <td align="left" style="text-align: left">' . $client_location->geoplugin_countryName . '</td>
            <td align="right" style="text-align: right">' . $client_location->geoplugin_city . '</td>
          </tr>
        </table>
      </div>
    </td>
  </tr>
</table>';


        $mail = new PHPMailer(true);
        $mail->CharSet = "UTF-8";

        try {

            // Server Settings
            // $mail->SMTPDebug = SMTP::DEBUG_SERVER;                     
            $mail->isSMTP();
            // $mail->SMTPDebug = SMTP::DEBUG_SERVER;
            $mail->Host       = 'smtp.gmail.com';
            $mail->SMTPAuth   = true;
            $mail->Username   = 'hello@salkantaytrekking.com';
            $mail->Password   = 'xvlnwlzodmodfwpq';
            $mail->Port       = 587;
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;

            // Recipientsf
            $mail->SetFrom("hello@salkantaytrekking.com", $data['first_name'] . ' ' . $data['last_name']);
            $mail->AddReplyTo("sales@salkantaytrekking.com", $data['first_name'] . ' ' . $data['last_name']);
            $mail->AddAddress($data['email'], "Salkantay Trekking");
            // $mail->addBCC('edgar@salkantaytrekking.com');
            // $mail->addBCC('marketing@salkantaytrekking.com');

            $mail->isHTML(true);
            $mail->Subject  = "Book Now: " .  $data['first_name'] . ' ' . $data['last_name']  . " | " .  $data['trip_name'] . " | " . $data['departure_date'];
            $mail->MsgHTML($html_top . $message_body . $html_bottom);
            $mail->Send();
            echo "<span class='response-box success'>Your message was sent successfully! <br> We'll contact you soon attending all your requests.<span><h3 class='center'><strong>THANK YOU SO MUCH FOR CHOOSING SALKANTAY TREKKING!</strong></h3>";
        } catch (Exception $e) {
            echo "<span class='response-box danger'>Your message could not be sent. Really sorry for the inconvenience, we'll solve this technical issue as soon as possible. <br> Please, reach us via email at <a href='mailto:sales@salkantaytrekking.com'>sales@salkantaytrekking.com</a>
  or by calling us directly at <a href='tel:+51 958 191 179'>+51 958 191 179</a>. </span>" . $e;
        }
    }
}
