<?php

namespace App\Http\Controllers\Owner\Info;

use App\Http\Controllers\Client\c_Booking;
use App\Http\Controllers\Owner\BookingCreator;
use App\Http\Controllers\Owner\Passenger\PassengerUpdater;
use App\Http\Helpers\ParamsValidator;
use App\Modules\PackageFee\Application\GetFull\PackageFeeGetFullQuery;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Throwable;

class BookingGenerator
{

    public static function from($user, $niubizPurchase, $data)
    {
        $request = new Request(
            [
                'Id_User'               => $user->Id_User,
                'User_Name'             => $niubizPurchase->BookingTemp_User_Name,
                'User_LastName'         => $niubizPurchase->BookingTemp_User_LastName,
                'User_Email'            => $niubizPurchase->BookingTemp_User_Email,
                'User_Phone'            => $niubizPurchase->BookingTemp_User_Phone,
                'Id_UserCountry'        => $niubizPurchase->BookingTemp_Id_UserCountry,
                'Booking'               => $niubizPurchase->BookingTemp_Booking,
                'CashMovement'          => json_encode(
                    [
                        'CashMovement_Amount' => $data->order->amount,
                        'CashMovement_Currency' => $data->order->currency,
                        'CashMovement_Name' => '-',
                        'CashMovement_LastName' => '-',
                        'CashMovement_Email' => '-',
                        'CashMovement_Country' => '-',
                        'CashMovement_City' => '-',
                        'CashMovement_Address' => '-',
                        'CashMovement_Phone' => '-',
                        'CashMovement_DatePayment' => date('Y-m-d H:i:s', strtotime($niubizPurchase->BookingTemp_Date) - 5 * 60 * 60),
                        'CashMovement_ReceiptNumber' => $data->order->purchaseNumber,
                        'CashMovement_CardLast' => '-',
                        'CashMovement_CardNumber' => $data->dataMap->CARD,
                        'CashMovement_CardBrand' => $data->dataMap->BRAND,
                        'CashMovement_CardType' => '-',
                        'CashMovement_CardIssuer' => '-',
                    ]
                ),
            ]
        );
        $request->headers->set('Token', $niubizPurchase->BookingTemp_Token);
        return $request;
    }


    public static function generate(
        Request $Request,
        $queryBus,
        BookingCreator $bookingCreator,
        PassengerUpdater $passengerUpdater
    ) {
        $cBooking = new c_Booking($queryBus, $bookingCreator, $passengerUpdater);

        $Id_User            = 0;
        $Id_Booking         = 0;
        $Id_BookingTour     = 0;
        $Id_BookingUpgrade  = 0;
        $Id_BookingExtra    = 0;
        $Token              = "";
        $oData              = null;
        $Response_Data = null;

        $oResponse  = array();
        $oValParams = array(
            'Id_User'               => 'int',
            'User_Name'             => 'required|string|max:100',
            'User_LastName'         => 'required|string|max:100',
            'User_Email'            => 'required|string|max:250',
            'User_Phone'            => 'string|max:20',
            'Id_UserCountry'        => 'required|int',
            'Booking'               => 'required|string',
            'CashMovement'          => 'required|string'
        );

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, 'Booking');

        if ($oResponse["Response_Code"] == 200) {

            $userId = $Request->input('Id_User');
            $Token      = $Request->header("Token");
            if ($Request->input('Id_User') == 0) {
                $oClient = DB::select('CALL sp_client_user_validate(?)', [$Request->input('User_Email')]);
                if ($oClient[0]->Response_Id != null) {
                    $userId = $oClient[0]->Response_Id;
                    $Token = DB::select('CALL sp_client_user_session_insert_empty(?)', [$userId])[0]->Response_Token;
                }
            }

            if ($userId == 0) {
                $oParam     = [
                    $Request->input("User_Name"),
                    $Request->input("User_LastName"),
                    $Request->input("User_Email"),
                    $Request->input("User_Phone"),
                    $Request->input("Id_UserCountry")
                ];

                $oData_User = DB::select('call sp_client_user_insert(?,?,?,?,?)', $oParam);
                $Id_User = $oData_User[0]->Response_Id;

                $oParam = array(
                    $oData_User[0]->Response_User_Email,
                    $oData_User[0]->Response_Password
                );

                $oData_User_Session = DB::select('call sp_client_user_session_insert(?,SHA1(?))', $oParam);

                $Token              = $oData_User_Session[0]->Response_Token;
            } else {
                $Id_User    = $userId;
            }

            //
            //  DESERIALIZA DATOS DE LA RESERVA
            //
            $oBooking       = json_decode($Request->input("Booking"));

            $oCashMovement  = json_decode($Request->input("CashMovement"));

            $oParam = [
                $oCashMovement->CashMovement_DatePayment,
                $oCashMovement->CashMovement_Amount,
                $oCashMovement->CashMovement_Currency,
                $Request->input("User_Name"),
                $Request->input("User_LastName"),
                $oCashMovement->CashMovement_Email,
                $oCashMovement->CashMovement_Country,
                $oCashMovement->CashMovement_City,
                $oCashMovement->CashMovement_Address,
                $oCashMovement->CashMovement_Phone,
                $oCashMovement->CashMovement_ReceiptNumber,
                $oCashMovement->CashMovement_CardLast,
                $oCashMovement->CashMovement_CardNumber,
                $oCashMovement->CashMovement_CardBrand,
                $oCashMovement->CashMovement_CardType,
                $oCashMovement->CashMovement_CardIssuer,
                '',
                2
            ];

            $oDataCashMovement = DB::select('call sp_cash_movement_insert(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,0)', $oParam);

            if ($oDataCashMovement[0]->Response_Success) {
                $Id_CashMovement = $oDataCashMovement[0]->Id_CashMovement;
                if (count($oBooking) > 0) {
                    $oData = $oData_Booking = $cBooking->insertGenericBooking($oBooking[0], $Id_User);

                    if ($oData_Booking[0]->Response_Success == 1) {
                        $Id_Booking = $oData_Booking[0]->Response_Id;

                        /** @var $oBookingHighPassenger */
                        $oBookingHighPassenger = $cBooking->getBookingHighPassenger($oBooking);

                        $cBooking->insertPassengerList($oBookingHighPassenger->Passenger, $Id_Booking);

                        $oPassenger = $cBooking->listPassengers($Id_Booking);

                        foreach ($oBooking as $k => $oBookingElement) {

                            $oTour          = $oBooking[$k]->Tour;

                            foreach ($oTour as $j => $oTourElement) {

                                try {
                                    /** @var PackageFeeGetFullQueryResponse $response */
                                    $response = $queryBus->ask(new PackageFeeGetFullQuery($oBooking[$k]->Id_Package));

                                    $oParam         = array(
                                        $oTour[$j]->BookingTour_DateStart,
                                        $oBooking[$k]->Booking_Type,
                                        $oBooking[$k]->Booking_NoPax,
                                        $response->packageFeeType(),
                                        $response->packageFeeTotal(),
                                        $oBooking[$k]->Id_Package,
                                        $Id_Booking,
                                        $oTour[$j]->Id_Tour,
                                        $k + 1
                                    );

                                    $oData_Tour     = DB::select('call sp_booking_tour_insert_unregistered(?,?,?,?,?,?,?,?,?)', $oParam);

                                    $Id_BookingTour = $oData_Tour[0]->Response_Id;
                                    $oUpgrade       = $oTour[$j]->Upgrade;
                                    $oExtra         = $oTour[$j]->Extra;

                                    for ($h = 0; $h < count($oPassenger) && $h < $oBookingElement->Booking_NoPax; $h++) {

                                        $oParam                 = array(
                                            $Id_BookingTour,
                                            $oPassenger[$h]->Id_Passenger,
                                            count($oPassenger)
                                        );

                                        $oData_TourPassenger    = DB::select('call sp_booking_tour_passenger_insert(?,?,?)', $oParam);
                                    }

                                    $oParam = array(
                                        "all",
                                        $Id_BookingTour,
                                        0,
                                        ''
                                    );

                                    $oTourPassenger = DB::select('call sp_booking_tour_passenger_list(?,?,?,?)', $oParam);

                                    for ($i = 0; $i < count($oUpgrade); $i++) {

                                        $oParam             = array(
                                            $oBooking[$k]->Booking_NoPax,
                                            "",
                                            1,
                                            $Id_BookingTour,
                                            0,
                                            $oUpgrade[$i]->Id_Upgrade,
                                            1,
                                            1
                                        );

                                        $oData_Upgrade      = DB::select('call sp_booking_upgrade_insert(?,?,?,?,?,?,?,?)', $oParam);
                                        $Id_BookingUpgrade  = $oData_Upgrade[0]->Response_Id;

                                        for ($h = 0; $h < count($oTourPassenger); $h++) {


                                            $oParam                     = array(
                                                $Id_BookingUpgrade,
                                                $oTourPassenger[$h]->Id_BookingTourPassenger,
                                                1
                                            );
                                            $oData_UpgradePassenger     = DB::select('call sp_booking_upgrade_passenger_insert(?,?,?)', $oParam);
                                        }
                                    }

                                    for ($i = 0; $i < count($oExtra); $i++) {

                                        $oParam             = array(
                                            $oBooking[$k]->Booking_NoPax,
                                            " ",
                                            1,
                                            $Id_BookingTour,
                                            0,
                                            $oExtra[$i]->Id_Extra,
                                            1,
                                            1
                                        );

                                        $oData_Extra        = DB::select('call sp_booking_extra_insert(?,?,?,?,?,?,?,?)', $oParam);
                                        $Id_BookingExtra    = $oData_Extra[0]->Response_Id;

                                        for ($h = 0; $h < count($oTourPassenger); $h++) {

                                            $oParam                 = array(
                                                $Id_BookingExtra,
                                                $oTourPassenger[$h]->Id_BookingTourPassenger,
                                                1
                                            );

                                            $oData_ExtraPassenger   = DB::select('call sp_booking_extra_passenger_insert(?,?,?)', $oParam);
                                        }
                                    }

                                    DB::select('CALL sp_booking_tour_add_items_from_package_tour(?,?)', [$Id_BookingTour, 1]);
                                } catch (Throwable $th) {
                                }
                            }
                        }

                        $passengerLength = count($oPassenger);

                        for ($i = 0; $i < $passengerLength; $i++) {
                            $oParam = [
                                $Id_Booking,
                                $oPassenger[$i]->Id_Passenger,
                                1
                            ];

                            $oData_Invoice  = DB::select('call sp_invoice_insert(?,?,?)', $oParam);

                            $oData          = $oData_Invoice;
                            $sum = 0;
                            foreach ($oBooking as $j => $booking) {
                                if ($i >= $booking->Booking_NoPax) {
                                    continue;
                                }
                                $sum += $booking->CashMovementDetail_Amount / $booking->Booking_NoPax;
                            }

                            DB::select(
                                'call sp_cash_movement_detail_insert(?,?,?,?,?)',
                                [
                                    $sum,
                                    $oDataCashMovement[0]->Id_CashMovement,
                                    $oData_Invoice[0]->Response_Id,
                                    1,
                                    1
                                ]
                            );
                        }
                    }
                }
            } else {
                $oData = $oDataCashMovement;
            }

            $Response_Data  = array(
                "Id_Booking"    => $Id_Booking,
                "Id_User"       => $Id_User,
                "Token"         => $Token
            );


            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = 'Booking';
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = $Response_Data;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }
        if ($oResponse["Response_Status"] == 200) {
            return $oResponse;
        }

        return $oResponse;
    }
}
