<?php

namespace App\Http\Controllers\Owner\HtlTypeRoom;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\HtlTypeRoom\Application\Update\UpdateHtlTypeRoomQuery;
use App\Modules\HtlTypeRoom\Infrastructure\HtlTypeRoomValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class HtlTypeRoomUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "HtlTypeRoom";
        $this->history = new HistoryData(HistoryTables::HTL_TYPE_ROOM);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, HtlTypeRoomValidators::UPDATE);
        $this->history->obtainOld($request->input('Id_HtlTypeRoom'));
        $this->transaction->begin();
        $this->queryBus->ask(new UpdateHtlTypeRoomQuery(
            $request->input('Id_HtlTypeRoom'),
            $request->input('HtlTypeRoom_Name'),
            $request->input('HtlTypeRoom_Abrv'),
            $request->input('HtlTypeRoom_Status'),
        ));
        $this->transaction->commit();
        $this->history->updateBasic($request->input('Id_HtlTypeRoom'), $request);
        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Tipo de Habitación modificado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
