<?php
namespace App\Http\Controllers\Owner\HtlTypeCamp;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\HtlTypeCamp\Application\HtlTypeCampResponse;
use App\Modules\HtlTypeCamp\Application\Index\IndexHtlTypeCampQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class HtlTypeCampIndexController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "HtlTypeCamp";
    }

    public function __invoke($Id)
    {
        $this->transaction->begin();
        /** @var HtlTypeCampResponse $response */
        $response = $this->queryBus->ask(new IndexHtlTypeCampQuery($Id));
        $this->transaction->commit();

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [ $response ],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Tipo de Campamento agregado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
