<?php
namespace App\Http\Controllers\Owner\HtlCampBookingPassenger;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\HtlCampBookingPassenger\Application\HtlCampBookingPassengerResponse;
use App\Modules\HtlCampBookingPassenger\Application\Index\IndexHtlCampBookingPassengerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Transaction;

class HtlCampBookingPassengerIndexController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "HtlCampBookingPassenger";
    }

    public function __invoke($Id)
    {
        $this->transaction->begin();
        /** @var HtlCampBookingPassengerResponse $response */
        $response = $this->queryBus->ask(new IndexHtlCampBookingPassengerQuery($Id));
        $this->transaction->commit();

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => [ $response ],
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Index',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
