<?php

namespace App\Http\Controllers\Owner\HtlCampBooking;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\HtlCampBooking\Application\List\ListHtlCampBookingQuery;
use App\Modules\HtlCampBooking\Application\List\ListHtlCampBookingResponses;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\ImageUtils;
use App\Modules\Shared\Domain\Transaction;
use Illuminate\Http\Request;

class HtlCampBookingListController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction
    ) {
        $this->domain = "HtlCampBooking";
    }

    public function __invoke(Request $request, $Id_BookingTour, $Action)
    {
        $this->transaction->begin();
        /** @var ListHtlCampBookingResponses $response */
        $response = $this->queryBus->ask(new ListHtlCampBookingQuery($Id_BookingTour, $Action));
        $responseData = array_map(
            fn ($htlCamp) => self::appendPath($htlCamp),
            $response->data()
        );
        $this->transaction->commit();

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => $responseData,
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Listado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }

    public static function appendPath($htlCamp)
    {
        ImageUtils::appendPath($htlCamp, 'HtlCamp_Icon');
        return ImageUtils::appendPath($htlCamp, 'HtlCamp_Icon_Thumb');
    }
}
