<?php

namespace App\Http\Controllers\Owner\GroupProvider;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ParamsValidator;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\GroupProvider\Application\Report\ReportGroupProviderQuery;
use App\Modules\GroupProvider\Application\Report\ReportGroupProviderResponse;
use App\Modules\GroupProvider\Infraestructure\GroupProviderValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Providers\ExcelGroupProviderReport\ExcelGroupProviderReport;
use Illuminate\Http\Request;

final class GroupProviderReviewExportToExcelController extends Controller
{
    private string $domain = 'GroupProvider';

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke(Request $Request)
    {
        $oResponse = ParamsValidator::Validate_Request($Request, GroupProviderValidators::EXPORT_TO_EXCEL, $this->domain);
        if ($oResponse["Response_Code"] != 200) {
            return ResponseBuilder::Response($oResponse);
        }

        /** @var ReportGroupProviderResponse $response */
        $response = $this->queryBus->ask(new ReportGroupProviderQuery($Request->input('DateStart'), $Request->input('DateEnd')));
        // dd($response->response());
        (new ExcelGroupProviderReport())->exportToExcel($response->response());
    }
}
