<?php

namespace App\Http\Controllers\Owner\GroupProvider;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\GroupProvider\Application\ListGallery\ListGalleryGroupProviderQuery;
use App\Modules\GroupProvider\Infraestructure\GroupProviderValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Domain\Transaction;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;

final class GroupProviderListGalleryController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus,
        private Transaction $transaction,
    ) {
        $this->domain = "GroupProvider";
    }

    public function __invoke(Request $request, $Action)
    {
        (new LaravelValidator())->validate(
            $request->all(),
            $this->domain,
            GroupProviderValidators::LIST_GALLERY
        );

        /** @var GroupProviderMediaResponses $response */
        $response = $this->queryBus->ask(new ListGalleryGroupProviderQuery(
            new DateStart($request->input('DateStart')),
            new DateEnd($request->input('DateEnd')),
            trim($request->input('Search', '')),
            trim($Action),
            $request->input('Page', null),
            $request->input('PageSize', null),
        ));
        $data = $response->data();

        return ResponseBuilder::Response([
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Data"             => $data,
            "Response_Domain"           => $this->domain,
            "Response_Message"          => 'Listado con éxito',
            "Response_Error_Message"    => '',
            "Response_Error_Reason"     => '',
        ]);
    }
}
