<?php

namespace App\Http\Controllers\Owner\GroupPassenger;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ParamsValidator;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\GroupPassenger\Application\Report\ReportGroupPassengerResponse;
use App\Modules\GroupPassenger\Application\ReportCategorized\ReportCategorizedGroupPassengerQuery;
use App\Modules\GroupPassenger\Infraestructure\GroupPassengerValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Providers\ExcelGroupPassengerReportCategorized\ExcelGroupPassengerReportCategorized;
use Illuminate\Http\Request;

final class GroupPassengerReviewExportToExcelCategorizedController extends Controller
{
    private string $domain = 'GroupPassenger';

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke(Request $Request)
    {
        $oResponse = ParamsValidator::Validate_Request(
            $Request,
            GroupPassengerValidators::EXPORT_TO_EXCEL,
            $this->domain
        );

        if ($oResponse["Response_Code"] != 200) {
            return ResponseBuilder::Response($oResponse);
        }

        /** @var ReportGroupPassengerResponse $response */
        $response = $this->queryBus->ask(new ReportCategorizedGroupPassengerQuery(
            $Request->input('DateStart'),
            $Request->input('DateEnd')
        ));
        (new ExcelGroupPassengerReportCategorized())->exportToExcel($response->response());
    }
}
