<?php

namespace App\Http\Controllers\Owner\FactTypeOperation;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\FactTypeOperation\Application\FactTypeOperationResponses;
use App\Modules\FactTypeOperation\Application\List\FactTypeOperationListerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class FactTypeOperationListController extends Controller
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Action)
    {
        /** @var FactTypeOperationResponses $response */
        $response = $this->queryBus->ask(new FactTypeOperationListerQuery($Action));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse($response->data()));
    }
}
