<?php

namespace App\Http\Controllers\Owner\FactReceipt;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\FactReceipt\Application\Send\SendFactReceiptQuery;
use App\Modules\FactReceipt\Application\Send\SendFactReceiptResponse;
use App\Modules\FactReceipt\Application\Update\FactReceiptUpdaterQuery;
use App\Modules\FactReceipt\Infraestructure\FactReceiptValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;

/**
 * This class is a controller for creating fact receipts.
 */
class FactReceiptSendController
{

    private $domain;
    private HistoryData $history;

    /**
     * Constructs a new instance of the class.
     *
     * @param QueryBus $queryBus The query bus instance.
     */
    public function __construct(
        private QueryBus $queryBus,
    ) {
        $this->domain = "FactReceipt";
        $this->history = new HistoryData(HistoryTables::FACT_RECEIPT);
    }

    /**
     * Validates the request, creates a new fact receipt, creates an history entry and returns the created fact receipt.
     */
    public function __invoke(Request $request, $Id_FactReceipt)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, FactReceiptValidators::UPDATE);

        $this->history->obtainOld($request->input("Id_FactReceipt"));

        /** @var FactReceiptUpdaterResponse $response */
        $response = $this->queryBus->ask(new FactReceiptUpdaterQuery(
            $request->input('Id_FactReceipt'),
            $request->input('FactReceipt_DateEmission'),
            $request->input('FactReceipt_NoDocument'),
            $request->input('FactReceipt_BusinessName'),
            $request->input('FactReceipt_Email'),
            $request->input('FactReceipt_Address'),
            '',
            $request->input('FactReceipt_Currency'),
            $request->input('Id_FactTypeReceipt'),
            $request->input('Id_FactTypeDocument'),
            $request->input('Id_FactPaymentMethod'),
            $request->input('Id_FactCurrency'),
        ));
        /**
         * @var SendFactReceiptResponse $response
         */
        $response = $this->queryBus->ask(new SendFactReceiptQuery($Id_FactReceipt));

        $this->history->updateBasic($Id_FactReceipt, $request);
        return ResponseBuilder::Response($response->response());
    }
}
