<?php

namespace App\Http\Controllers\Owner\FactProduct;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\FactProduct\Application\Update\FactProductUpdaterQuery;
use App\Modules\FactProduct\Application\Update\FactProductUpdaterResponse;
use App\Modules\FactProduct\Infraestructure\FactProductValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class FactProductUpdateController extends Controller
{
    private $domain;
    private HistoryData $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "FactProduct";
        $this->history = new HistoryData(HistoryTables::FACT_PRODUCT);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, FactProductValidators::UPDATE);

        $this->history->obtainOld($request->input("Id_FactProduct"));

        /** @var FactProductUpdaterResponse $response */
        $response = $this->queryBus->ask(new FactProductUpdaterQuery(
            $request->input('Id_FactProduct'),
            $request->input('FactProduct_Code'),
            $request->input('FactProduct_Name'),
            $request->input('FactProduct_IdProduct'),
            $request->input('FactProduct_Status'),
            $request->input('Id_FactUnit'),
        ));

        $this->history->updateBasic($request->input("Id_FactProduct"), $request);
        return ResponseBuilder::Response($response->response());
    }
}
