<?php
namespace App\Http\Controllers\Owner\FactProduct;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\FactProduct\Application\FactProductResponse;
use App\Modules\FactProduct\Application\Index\FactProductIndexerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class FactProductIndexController extends Controller
{

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var FactProductResponse $response */
        $response = $this->queryBus->ask(new FactProductIndexerQuery($Id));

        return ResponseBuilder::Response(ResponseBuilder::buildSelectResponse([$response]));
    }
}
