<?php

namespace App\Http\Controllers\Owner\ExternalUserPassenger;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\ExternalUser\Domain\IdExternalUser;
use App\Modules\ExternalUserPassenger\Application\ExternalUserPassengerIndexer;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\ExternalUserPassenger\Application\ExternalUserPassengerInserter;
use App\Modules\ExternalUserPassenger\Domain\ExternalUserPassenger;
use App\Modules\ExternalUserPassenger\Domain\ExternalUserPassengerStatus;
use App\Modules\ExternalUserPassenger\Domain\IdExternalUserPassenger;
use App\Modules\ExternalUserPassenger\Infraestructure\MysqlExternalUserPassengerRepository;
use App\Modules\ExternalUserPassenger\Infraestructure\ExternalUserPassengerValidators;
use App\Modules\Passenger\Domain\IdPassenger;

class ExternalUserPassengerInsertController extends Controller
{
    private $domain;
    /** @var HistoryData */
    private $history;

    private ExternalUserPassengerInserter $inserter;
    private ExternalUserPassengerIndexer $indexer;

    public function __construct()
    {
        $this->domain = "ExternalUserPassenger";
        $this->history = new HistoryData(HistoryTables::EXTERNAL_USER_PASSENGER);
        $this->inserter = new ExternalUserPassengerInserter(new MysqlExternalUserPassengerRepository());
        $this->indexer = new ExternalUserPassengerIndexer(new MysqlExternalUserPassengerRepository());
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, ExternalUserPassengerValidators::INSERT);

        $response = $this->inserter->__invoke(
            new ExternalUserPassenger(
                new ExternalUserPassengerStatus($request->input('ExternalUserPassenger_Status')),
                new IdExternalUser($request->input('Id_ExternalUser')),
                new IdPassenger($request->input('Id_Passenger')),
            )
        );
        $this->history->insertBasic($request, true);

        return ResponseBuilder::Response($response);
    }
}
