<?php

namespace App\Http\Controllers\Owner\ExternalReviewProvider;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\ExternalReview\Domain\IdExternalReview;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\ExternalReviewProvider\Application\ExternalReviewProviderUpdater;
use App\Modules\ExternalReviewProvider\Domain\IdExternalReviewProvider;
use App\Modules\ExternalReviewProvider\Domain\ExternalReviewProvider;
use App\Modules\ExternalReviewProvider\Domain\ExternalReviewProviderStatus;
use App\Modules\ExternalReviewProvider\Domain\ExternalReviewProviderType;
use App\Modules\ExternalReviewProvider\Infraestructure\MysqlExternalReviewProviderRepository;
use App\Modules\ExternalReviewProvider\Infraestructure\ExternalReviewProviderValidators;
use App\Modules\GroupProvider\Domain\IdGroupProvider;

class ExternalReviewProviderUpdateController extends Controller
{
    private $domain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->domain = "ExternalReviewProvider";
        $this->history = new HistoryData(HistoryTables::EXTERNAL_REVIEW);
    }

    public function __invoke(Request $Request)
    {
        (new LaravelValidator())->validate($Request->all(), $this->domain, ExternalReviewProviderValidators::INSERT);

        $this->history->obtainOld($Request->input("Id_ExternalReviewProvider"));

        $response = (new ExternalReviewProviderUpdater(new MysqlExternalReviewProviderRepository()))
            ->__invoke(new ExternalReviewProvider(
                new ExternalReviewProviderType($Request->input('ExternalReviewProvider_Type')),
                new ExternalReviewProviderStatus($Request->input('ExternalReviewProvider_Status')),
                new IdExternalReview($Request->input('Id_ExternalReview')),
                new IdGroupProvider($Request->input('Id_GroupProvider')),
                new IdExternalReviewProvider($Request->input('Id_ExternalReviewProvider'))
            ));

        $this->history->updateBasic($Request->input("Id_ExternalReviewProvider"), $Request);

        return ResponseBuilder::Response($response);
    }
}
