<?php

namespace App\Http\Controllers\Owner\BookingUpgradePassenger;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\BookingUpgradePassenger\Application\Mask\MaskBookingUpgradePassengerQuery;
use App\Modules\BookingUpgradePassenger\Application\Mask\MaskBookingUpgradePassengerResponse;
use App\Modules\BookingUpgradePassenger\Infrastructure\BookingUpgradePassengerValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Support\Facades\DB;

class BookingUpgradePassengerMaskController extends Controller
{
    private $domain;
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "BookingUpgradePassenger";
        $this->history = new HistoryData(HistoryTables::BOOKING_UPGRADE_PASSENGER);
    }

    public static function findBooking($Id_BookingUpgradePassenger)
    {
        $found = DB::select('SELECT `fn_booking_tour_detail_passenger_find_booking`(?,?) as Id_Booking', [$Id_BookingUpgradePassenger, 1]);
        return count($found) ? $found[0]->Id_Booking : null;
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator)->validate($request->all(), 'Booking', BookingUpgradePassengerValidators::MASK);

        $this->history->obtainOld($request->input('Id_BookingUpgradePassenger'));

        /** @var MaskBookingUpgradePassengerResponse $response */
        $response = $this->queryBus->ask(new MaskBookingUpgradePassengerQuery(
            $request->input('Id_BookingUpgradePassenger'),
            $request->input('BookingUpgradePassenger_Mask')
        ));

        $this->history->update($this->findBooking($request->input('Id_BookingUpgradePassenger')), $this->history->oldValue, [], $request);
        return ResponseBuilder::Response($response->response());
    }
}
