<?php

namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;
use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\HtlCampBooking\Application\CreateWithPassengers\CreateWithPassengersHtlCampBookingQuery;
use App\Modules\HtlCampBooking\Application\List\ListHtlCampBookingQuery;
use App\Modules\HtlCampBooking\Application\List\ListHtlCampBookingResponses;
use App\Modules\HtlCampBooking\Application\UpdateDateStart\UpdateDateStartHtlCampBookingQuery;
use App\Modules\HtlCampBooking\Domain\ListHtlCampBooking;
use App\Modules\HtlCampBookingPassenger\Application\Create\CreateHtlCampBookingPassengerQuery;
use App\Modules\HtlCampBookingPassenger\Domain\HtlCampBookingPassengerStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Domain\DateUtils;
use App\Modules\TourHtlCamp\Application\TourHtlCampFinder;
use App\Modules\TourHtlCamp\Domain\THCIdTour;
use App\Modules\TourHtlCamp\Infraestructure\MysqlTourHtlCampRepository;

class BookingCreator extends Controller
{

    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function addHtlCampBookingPassenger($idHtlCampBooking, $idBookingTourPassenger)
    {
        return $this->queryBus->ask(new CreateHtlCampBookingPassengerQuery(1, HtlCampBookingPassengerStatus::INACTIVE, $idHtlCampBooking, $idBookingTourPassenger));
    }

    public function addPassengerToAllHtlCamps($camps, $idBookingTourPassenger)
    {
        return array_map(fn ($camp) => $this->addHtlCampBookingPassenger(
            $camp->id(),
            $idBookingTourPassenger
        ), $camps);
    }

    public function addHtlCampBookings($idBookingTour, $bookingTourDateStart, $idTour)
    {
        $tourCamps = $this->getBookingTourCamps($idTour);
        $campResponses = [];
        foreach ($tourCamps as $tourCamp) {
            $campResponses[] = $this->addBookingTourToSchedule(
                $idBookingTour,
                $bookingTourDateStart,
                $tourCamp->Id_HtlCamp,
                $tourCamp->TourHtlCamp_Day
            );
        }
        return $campResponses;
    }
    public function getHtlCampBookings($idBookingTour): ListHtlCampBookingResponses
    {
        return $this->queryBus->ask(new ListHtlCampBookingQuery($idBookingTour, 'all'));
    }

    public function getBookingTourCamps($idTour)
    {
        return (new TourHtlCampFinder(new MysqlTourHtlCampRepository))
            ->__invoke(new THCIdTour($idTour), 'active')['Response_Data'];
    }

    public function changeDate($idBookingTour, $bookingTourDateStart, $oldDateStart)
    {
        $difference = DateUtils::dateDiferenceInDays($bookingTourDateStart, $oldDateStart);
        /** @var ListHtlCampBookingResponses $htlCampBooking */
        $htlCampBooking = $this->queryBus->ask(new ListHtlCampBookingQuery($idBookingTour, 'all'));
        $list = [];
        foreach ($htlCampBooking->data() as $htlCamp) {
            $list = $this->queryBus->ask(new UpdateDateStartHtlCampBookingQuery(
                $htlCamp->Id_HtlCampBooking,
                DateUtils::changeDate($htlCamp->HtlCampBooking_DateStart, $difference) . ' 00:00:00'
            ));
        }
        return $list;
    }

    public function addBookingTourToSchedule($idBookingTour, $bookingTourDateStart, $idHtlCamp, $tourHtlCampDay)
    {
        $dateStart = new DateStart($bookingTourDateStart);
        $dateStart->addInterval('P' . ($tourHtlCampDay - 1) . 'D');
        return $this->queryBus->ask(new CreateWithPassengersHtlCampBookingQuery(
            $dateStart->value() . ' 00:00:00',
            $idHtlCamp,
            $idBookingTour,
            []
        ));
    }
}
