<?php

namespace App\Http\Controllers\Owner\Booking;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Booking\Application\UpdateManuallyConfirmed\UpdateManuallyConfirmedQuery;
use App\Modules\Booking\Application\UpdateManuallyConfirmed\UpdateManuallyConfirmedResponse;
use App\Modules\Booking\Infraestructure\BookingValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;

class BookingUpdateManuallyConfirmedController extends Controller
{
    /** @var HistoryData */
    private $history;

    public function __construct(
        private QueryBus $queryBus,
        private BookingUpdater $bookingUpdater
    ) {
        $this->history = new HistoryData(HistoryTables::BOOKING);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator)->validate($request->all(), 'Booking', BookingValidators::UPDATE_MANUALLY_CONFIRMED);
        $this->history->obtainOld($request->input('Id_Booking'));
        /** @var UpdateManuallyConfirmedResponse $response */
        $response = $this->queryBus->ask(new UpdateManuallyConfirmedQuery(
            $request->input('Id_Booking'),
            $request->input('Booking_ManuallyConfirmed')
        ));

        $this->bookingUpdater->updatePassengers($request->input('Id_Booking'));

        $this->history->update(
            $request->input('Id_Booking'),
            $this->history->oldValue,
            [$request->all()],
            $request
        );

        return ResponseBuilder::Response($response->response());
    }
}
