<?php

namespace App\Http\Controllers\Owner\Batch;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\Batch\Application\Run\RunBatchQuery;
use App\Modules\Batch\Application\Run\RunBatchQueryResponse;
use App\Modules\Batch\Infrastructure\BatchValidators;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;

final class BatchController extends Controller
{
    private $domain;
    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "Batch";
    }

    public function __invoke(Request $request)
    {
        $oResponse  = array();

        (new LaravelValidator())->validate($request->all(), $this->domain, BatchValidators::INSERT);

        /** @var RunBatchQueryResponse $response */
        $response = $this->queryBus->ask(new RunBatchQuery(
            $request->input('Batch'),
            $request->header('Token'),
            $request->header('Url'),
            $request->ip()
        ));


        $oResponse["Response_Status"] = 200;
        $oResponse["Response_Code"] = 200;
        $oResponse["Response_Domain"] = $this->domain;
        $oResponse["Response_Message"] = $this->domain . " list";
        $oResponse["Response_Data"] = $response->response();
        $oResponse["Response_Error_Message"] = "";
        $oResponse["Response_Error_Reason"] = "";

        return ResponseBuilder::Response($oResponse);
    }
}
