<?php
namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use Illuminate\Support\Facades\DB;

class c_Tour_Lock extends Controller
{
	private $oDomain;

	public function __construct()
	{
		$this->oDomain = "Tour Lock";
	}

	public function Index(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {		
			$oParam = array( $Id );
			$oData 	= DB::select('call sp_tour_lock_index(?)',$oParam);
			
			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function List(Request $Request, $Id_Tour){
		$oResponse  = array();
		$oValParams = array(    'Month'		=> 'required|int',
								'Year'		=> 'required|int'
							);

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {

			$oResponse = ParamsValidator::Validate_Id($Id_Tour,$this->oDomain);

			if ($oResponse["Response_Code"] == 200) {
				$oParam = array(	$Id_Tour,
									$Request->input("Month"),
									$Request->input("Year")
								);
				$oData  = DB::select('call sp_tour_lock_list(?,?,?,0)',$oParam);

				$oResponse["Response_Status"]			= 200;
				$oResponse["Response_Code"]				= 200;
				$oResponse["Response_Domain"]			= $this->oDomain;
				$oResponse["Response_Message"]			= $this->oDomain." list";
				$oResponse["Response_Data"]				= $oData;
				$oResponse["Response_Error_Message"]	= "";
				$oResponse["Response_Error_Reason"]		= "";
			}
		}

		return ResponseBuilder::Response($oResponse);
	}
}