<?php

namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use Illuminate\Support\Facades\DB;

class c_Invoice extends Controller
{
    private $oDomain;

    public function __construct()
    {
        $this->oDomain = "Invoice";
    }

    public function Index(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam         = array($Id);
            $oData             = array_map(
                function ($invoice) {
                    $invoice->Invoice_Detail     = DB::select('call sp_client_invoice_detail_list(?)',    [$invoice->Id_Invoice]);
                    $invoice->Invoice_Fee         = DB::select('call sp_client_invoice_fee_list(?)',        [$invoice->Id_Invoice]);
                    return $invoice;
                },
                DB::select('call sp_client_invoice_index(?)', $oParam)
            );

            $Response_Data = count($oData) > 0 ? [$oData[0]] : null;

            $oResponse["Response_Status"]            = 200;
            $oResponse["Response_Code"]                = 200;
            $oResponse["Response_Domain"]            = $this->oDomain;
            $oResponse["Response_Message"]            = $this->oDomain . " Index";
            $oResponse["Response_Data"]                = $Response_Data;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]        = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function AllInfo(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);

        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam         = array($Id);
            $oData             = array_map(
                function ($invoice) {
                    $invoice->Booking = array_map(
                        function ($booking) {
                            $booking->Passenger = DB::select('CALL sp_passenger_list(?,?,?,?,?,?,?)', ['all', $booking->Id_Booking, 0, '', '', '', '']);
                            return $booking;
                        },
                        DB::select('call sp_booking_index(?)',    [$invoice->Id_Booking])
                    );
                    return $invoice;
                },
                DB::select('call sp_client_invoice_index(?)', $oParam)
            );

            $Response_Data = count($oData) > 0 ? [$oData[0]] : null;

            $oResponse["Response_Status"]            = 200;
            $oResponse["Response_Code"]                = 200;
            $oResponse["Response_Domain"]            = $this->oDomain;
            $oResponse["Response_Message"]            = $this->oDomain . " Index";
            $oResponse["Response_Data"]                = $Response_Data;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]        = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
}
