<?php

namespace App\Http\Controllers\Client\WebContactMessage;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\WebContact\Application\Create\CreateWebContactQuery;
use App\Modules\WebContact\Application\Create\CreateWebContactResponse;
use App\Modules\WebContact\Application\Find\FindWebContactQuery;
use App\Modules\WebContact\Application\Find\FindWebContactQueryResponse;
use App\Modules\WebContact\Domain\WebContactStatus;
use App\Modules\WebContactMessage\Application\Create\CreateWebContactMessageQuery;
use App\Modules\WebContactMessage\Application\Create\CreateWebContactMessageResponse;
use App\Modules\WebContactMessage\Domain\WebContactMessageStatus;
use App\Modules\WebContactMessage\Domain\WebContactMessageType;
use App\Modules\WebContactMessage\Infraestructure\WebContactMessageValidators;
use App\Modules\WebContactMessageDetail\Application\Create\CreateWebContactMessageDetailQuery;
use App\Modules\WebContactMessageDetail\Domain\WebContactMessageDetailStatus;

class WebContactMessageInsertController extends Controller
{
    private $domain;

    public function __construct(
        private QueryBus $queryBus
    ) {
        $this->domain = "WebContactMessage";
    }

    public function findOrGenerateContactResponse(
        $webContactEmail,
        Request $request
    ) {
        /** @var FindWebContactQueryResponse */
        $findWebContactResponse = $this->queryBus->ask(new FindWebContactQuery(
            $webContactEmail
        ));

        if (count($findWebContactResponse->response())) {
            return $findWebContactResponse->response()[0]->Id_WebContact;
        }

        /** @var CreateWebContactResponse $createWebContactResponse */
        $createWebContactResponse = $this->queryBus->ask(new CreateWebContactQuery(
            trim($request->input('WebContact_Name', '-')),
            trim($request->input('WebContact_LastName', '-')),
            $webContactEmail,
            $request->input('WebContact_Country', '-'),
            $request->input('WebContact_CountryCurrent', '-'),
            trim($request->input('WebContact_PhoneCode', '-')),
            trim($request->input('WebContact_Phone', '-')),
            WebContactStatus::defaultValue(),
            trim($request->input('Id_Country', 0)),
            trim($request->input('Id_Country_Current', 0)),
        ));
        return $createWebContactResponse->response()['Response_Data']['Id'];
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, WebContactMessageValidators::INSERT_CLIENT);

        $webContactEmail = trim($request->input('WebContact_Email', ''));

        $idWebContact = $this->findOrGenerateContactResponse($webContactEmail, $request);

        /** @var CreateWebContactMessageResponse $response */
        $response = $this->queryBus->ask(new CreateWebContactMessageQuery(
            $request->input('WebContactMessage_DateDeparture', date('Y-m-d H:i:s')),
            $request->input('WebContactMessage_DateSend', date('Y-m-d H:i:s')),
            $request->input('WebContactMessage_DateReception', date('Y-m-d H:i:s')),
            trim($request->input('WebContact_Name', '-')),
            trim($request->input('WebContact_LastName', '-')),
            trim($request->input('WebContact_Email', '-')),
            trim($request->input('WebContact_Country', '-')),
            trim($request->input('WebContact_CountryCurrent', '-')),
            trim($request->input('WebContact_PhoneCode', '-')),
            trim($request->input('WebContact_Phone', '-')),
            trim($request->input('Id_Country', 0)),
            trim($request->input('Id_CountryCurrent', 0)),
            trim($request->input('WebContactMessage_Message', '-')),
            $request->input('WebContactMessage_Adults', 0),
            ($request->input('WebContactMessage_Children') !== null && $request->input('WebContactMessage_Children') != '') ? $request->input('WebContactMessage_Children') : 0,
            $request->input('WebContactMessage_Subscription', 1),
            $request->input('WebContactMessage_Origin', ''),
            $request->input('WebContactMessage_Type', WebContactMessageType::ENQUIRE_NOW),
            WebContactMessageStatus::defaultValue(),
            $idWebContact,
            $request->input('Id_Language', 0),
        ));

        foreach ($request->input('WebContactMessageDetail', []) as $wcmd) {
            $this->queryBus->ask(new CreateWebContactMessageDetailQuery(
                $wcmd['WebContactMessageDetail_DateStart'],
                $wcmd['WebContactMessageDetail_Package'],
                WebContactMessageDetailStatus::defaultValue(),
                $response->response()['Response_Data']['Id'],
                $wcmd['Id_Package'] ?? 0
            ));
        }

        return ResponseBuilder::Response($response->response());
    }
}
