<?php

namespace App\Http\Controllers\Client\PaxInformation;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\PaxInformation\Application\PaxInformationGetBookingTour;
use App\Modules\PaxInformation\Infraestructure\MysqlPaxInformationSearchTokenRepository;
use App\Modules\PaxInformation\Application\PaxInformationTokenFinder;
use App\Modules\PaxInformation\Domain\IdPaxInformation;
use App\Modules\PaxInformation\Domain\PaxInformationToken;
use App\Modules\PaxInformation\Infraestructure\MysqlPaxInformationGetBookingTourRepository;
use App\Modules\PaxInformation\Infraestructure\Validators\PaxInformationSearchToken;
use App\Modules\PaxInformationPassenger\Infraestructure\MysqlPaxInformationPassengerRepository;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;

final class c_SearchToken extends Controller
{
    private $oDomain;

    public function __construct()
    {
        $this->oDomain = 'Cash Movement';
    }

    public function __invoke($PaxInformation_Token)
    {
        (new LaravelValidator)->validate(
            ['PaxInformation_Token' => $PaxInformation_Token],
            $this->oDomain,
            PaxInformationSearchToken::BASIC
        );

        $response = (new PaxInformationTokenFinder(
            new MysqlPaxInformationSearchTokenRepository,
            new MysqlPaxInformationPassengerRepository
        ))->__invoke(
            new PaxInformationToken($PaxInformation_Token),
        );
        $bookingTour = (new PaxInformationGetBookingTour(
            new MysqlPaxInformationGetBookingTourRepository
        ))->__invoke(
            new IdPaxInformation($response['Response_Data'][0]->Id_PaxInformation),
        );

        $response['Response_Data'][0]->BookingTour = $bookingTour['Response_Data'];

        return ResponseBuilder::Response($response);
    }
}
