<?php
namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Modules\Tour\Application\TourDaysGenerator;
use Illuminate\Support\Facades\DB;

class BookingTour extends Controller
{
    private $oDomain;

    public function __construct()
    {
        $this->oDomain = "Booking Tour";
    }

    public function calendarPax(Request $Request)
    {
        $oResponse  = array();
        $oValParams     = [
            'Id_tour'   => 'required|string|max:20',
            'Month'     => 'required|int',
            'Year'      => 'required|int'
        ];

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam     = array(    $Request->input("Id_tour"),
                                    $Request->input("Month"),
                                    $Request->input("Year"),
                                    0
                                );
            $availableDays  = DB::select('call sp_client_tour_availability(?,?,?,?)', $oParam);
            $locks  = DB::select('call sp_tour_lock_list(?,?,?,?)', $oParam);
            $oTour = DB::select('call sp_tour_index(?)', [ $Request->input("Id_tour") ]);
            
            $daysInMonth = cal_days_in_month(CAL_GREGORIAN, $Request->input("Month"), $Request->input("Year"));

            $oData = (new TourDaysGenerator())
            ->__invoke(
                $daysInMonth,
                $Request->input("Year") . '-' . $Request->input("Month") . '-',
                $oTour,
                $availableDays,
                $locks
            );
            
            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." Index ";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }
        return ResponseBuilder::Response($oResponse);
    }
}
