<?php

namespace App\DBTestSupport;

use Illuminate\Support\Facades\DB;

class TourMother {
    
    public static function buildClassic5($id = 1, $idCategoryTour = 1, $idTypeTour = 1, $idCountry = 1, $idState = 1, $idCity = 1) {
        return [
            'Id_Tour' => $id,
            'Tour_Code' => 'CL5',
            'Tour_Name' => 'Classic 5',
            'Tour_Duration' => 5,
            'Tour_MinPax' => 0,
            'Tour_Availability' => 10,
            'Tour_AvailabilityStatus' => 2,
            'Tour_Anticipation' => 0,
            'Tour_AnticipationType' => 1,
            'Tour_Color' => '#333',
            'Tour_Status' => 2,
            'Id_CategoryTour' => $idCategoryTour,
            'Id_TypeTour' => $idTypeTour,
            'Id_Country' => $idCountry,
            'Id_State' => $idState,
            'Id_City' => $idCity,
        ];
    }

    public static function pushClassic5($id = 1) {
        return self::push(self::buildClassic5($id));
    }
    
    public static function buildClassic4($id = 1, $idCategoryTour = 1, $idTypeTour = 1, $idCountry = 1, $idState = 1, $idCity = 1) {
        return [
            'Id_Tour' => $id,
            'Tour_Code' => 'CL4',
            'Tour_Name' => 'Classic 4',
            'Tour_Duration' => 4,
            'Tour_MinPax' => 0,
            'Tour_Availability' => 10,
            'Tour_AvailabilityStatus' => 2,
            'Tour_Anticipation' => 0,
            'Tour_AnticipationType' => 1,
            'Tour_Color' => '#333',
            'Tour_Status' => 2,
            'Id_CategoryTour' => $idCategoryTour,
            'Id_TypeTour' => $idTypeTour,
            'Id_Country' => $idCountry,
            'Id_State' => $idState,
            'Id_City' => $idCity,
        ];
    }

    public static function pushClassic4($id = 1) {
        return self::push(self::buildClassic4($id));
    }

    private static function push($object) {
        DB::select("CALL `sp_tour_insert` (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [
            $object['Tour_Code'],
            $object['Tour_Name'],
            $object['Tour_Duration'],
            $object['Tour_MinPax'],
            $object['Tour_Availability'],
            $object['Tour_AvailabilityStatus'],
            $object['Tour_Anticipation'],
            $object['Tour_AnticipationType'],
            $object['Tour_Color'],
            $object['Tour_Status'],
            $object['Id_CategoryTour'],
            $object['Id_TypeTour'],
            $object['Id_Country'],
            $object['Id_State'],
            $object['Id_City'],
        ]);
        return $object;
    }

}