<?php

namespace App\DBTestSupport;

use Illuminate\Support\Facades\DB;

class AdminSessionMother {
    
    public static function build1($id = 1) {
        return [
            'Id_AdminSession'			=> $id,
            'AdminSession_IP'			=> '127.0.0.1',
            'AdminSession_DateStart'	=> date('Y-m-d H:i:s'),
            'AdminSession_DateEnd'		=> date('Y-m-d H:i:s'),
            'AdminSession_Token'		=> '',
            'AdminSession_Status'		=> 2,
            'Id_Admin'					=> 1,
        ];
    }

    public static function push1($id, $Admin_Email, $Admin_Password) {
        return self::push(self::build1($id), $Admin_Email, $Admin_Password);
    }

    private static function push($object, $Admin_Email, $Admin_Password) {
        $response = DB::select("CALL `sp_admin_session_insert` (?,?,?)", [
            $Admin_Email,
            $Admin_Password,
            $object['AdminSession_IP'],
        ]);
        $object['AdminSession_Token'] = $response[0]->Response_Token;
        return $object;
    }

}