<?php

namespace App\DBTestSupport;

use Illuminate\Support\Facades\DB;

class AdminRoleMother {
    
    public static function build1($id = 1) {
        return [
            'Id_AdminRole'			=> $id,
            'AdminRole_Name'		=> 'Super Admin',
            'AdminRole_Abrv'		=> 'SADM',
            'AdminRole_Color'		=> '#FF0101',
            'AdminRole_Admin'		=> 2,
            'AdminRole_CalendarAccess'  => 2,
            'AdminRole_Status'		=> 2,
        ];
    }

    public static function push1($id = 1) {
        return self::push(self::build1($id));
    }

    private static function push($object) {
        DB::select("CALL `sp_admin_role_insert` (?,?,?,?,?,?)", [
            $object['AdminRole_Name'],
            $object['AdminRole_Abrv'],
            $object['AdminRole_Color'],
            $object['AdminRole_Admin'],
            $object['AdminRole_CalendarAccess'],
            $object['AdminRole_Status'],
        ]);
        return $object;
    }

}