<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;
use App\Modules\Shared\Application\Util;

class WebContactMother
{

    public static function build1($id = 1, $idCountry = null, $idCountryCurrent = null)
    {
        $faker = Factory::create();
        return [
            'Id_WebContact'             => $id,
            'WebContact_Name'           => $faker->text(rand(5, 250)),
            'WebContact_LastName'       => $faker->text(rand(5, 250)),
            'WebContact_Email'          => $faker->email(),
            'WebContact_Country'        => $faker->text(rand(5, 250)),
            'WebContact_CountryCurrent' => $faker->text(rand(5, 250)),
            'WebContact_PhoneCode'      => Util::generateString(10),
            'WebContact_Phone'          => $faker->text(rand(5, 100)),
            'WebContact_Status'         => $faker->randomElement([1, 2]),
            'Id_Country'                => $idCountry,
            'Id_Country_Current'        => $idCountryCurrent,
        ];
    }

    public static function push1($id = 1, $idCountry = null, $idCountryCurrent = null)
    {
        return self::push(self::build1($id, $idCountry, $idCountryCurrent));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_web_contact_insert` (?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg,@id)", [
            $object['WebContact_Name'],
            $object['WebContact_LastName'],
            $object['WebContact_Email'],
            $object['WebContact_Country'],
            $object['WebContact_CountryCurrent'],
            $object['WebContact_PhoneCode'],
            $object['WebContact_Phone'],
            $object['WebContact_Status'],
            $object['Id_Country'],
            $object['Id_Country_Current'],
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_WebContact'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return [TC::WEB_CONTACT];
    }
}
