<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;

class WebContactMessageMother
{

    public static function build1($idWebContact = null, $id = 1)
    {
        $idWebContact = $idWebContact ?? WebContactMother::push1()['Id_WebContact'];
        $idLanguage = $idLanguage ?? LanguageMother::push1()['Id_Language'];
        $faker = Factory::create();
        return [
            'Id_WebContactMessage'              => $id,
            'WebContactMessage_DateDeparture'  => date('Y-m-d H:i:s'),
            'WebContactMessage_DateSend'       => date('Y-m-d H:i:s'),
            'WebContactMessage_DateReception'  => date('Y-m-d H:i:s'),
            'WebContactMessage_Name'           => $faker->text(rand(5, 250)),
            'WebContactMessage_LastName'       => $faker->text(rand(5, 250)),
            'WebContactMessage_Email'          => $faker->email,
            'WebContactMessage_Country'        => $faker->text(rand(5, 250)),
            'WebContactMessage_CountryCurrent' => $faker->text(rand(5, 250)),
            'WebContactMessage_PhoneCode'      => $faker->text(rand(5, 10)),
            'WebContactMessage_Phone'          => $faker->text(rand(5, 100)),
            'WebContactMessage_Message'         => $faker->text(rand(5, 250)),
            'WebContactMessage_Adults'          => rand(1, 100),
            'WebContactMessage_Children'        => rand(1, 100),
            'WebContactMessage_Subscription'    => $faker->randomElement([1, 2]),
            'WebContactMessage_Origin'          => $faker->text(rand(5, 250)),
            'WebContactMessage_Type'            => $faker->randomElement([1, 2]),
            'WebContactMessage_Status'          => $faker->randomElement([1, 2]),
            'Id_WebContact'                     => $idWebContact,
            'Id_Country'                        => 0,
            'Id_Country_Current'                => 0,
            'Id_Language'                       => $idLanguage
        ];
    }

    public static function push1($idWebContact = null, $id = 1)
    {
        return self::push(self::build1($idWebContact, $id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_web_contact_message_insert` (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg,@id)", [
            $object['WebContactMessage_DateDeparture'],
            $object['WebContactMessage_DateSend'],
            $object['WebContactMessage_DateReception'],
            $object['WebContactMessage_Name'],
            $object['WebContactMessage_LastName'],
            $object['WebContactMessage_Email'],
            $object['WebContactMessage_Country'],
            $object['WebContactMessage_CountryCurrent'],
            $object['WebContactMessage_PhoneCode'],
            $object['WebContactMessage_Phone'],
            $object['Id_Country'],
            $object['Id_Country_Current'],

            $object['WebContactMessage_Message'],
            $object['WebContactMessage_Adults'],
            $object['WebContactMessage_Children'],
            $object['WebContactMessage_Subscription'],
            $object['WebContactMessage_Type'],
            $object['WebContactMessage_Status'],
            $object['WebContactMessage_Status'],
            $object['Id_WebContact'],
            $object['Id_Language'],
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_WebContactMessage'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return array_merge(
            WebContactMother::tablesToClear(),
            [
                TableCreation::WEB_CONTACT_MESSAGE,
                TableCreation::LANGUAGE
            ]
        );
    }
}
