<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;

class WebContactMessageDetailMother
{

    public static function build1($idWebContactMessage = null, $id = 1)
    {
        $idWebContactMessage = $idWebContactMessage ?? WebContactMessageMother::push1()['Id_WebContactMessage'];
        $faker = Factory::create();
        return [
            'Id_WebContactMessageDetail'          => $id,
            'WebContactMessageDetail_DateStart'   => date('Y-m-d'),
            'WebContactMessageDetail_Package'     => $faker->text(rand(5, 250)),
            'WebContactMessageDetail_Status'      => $faker->randomElement([1, 2]),
            'Id_WebContactMessage'                => $idWebContactMessage
        ];
    }

    public static function push1($idWebContactMessage = null, $id = 1)
    {
        return self::push(self::build1($idWebContactMessage, $id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_web_contact_message_detail_insert` (?,?,?,?,?,@sts,@cod,@msg,@id)", [
            $object['WebContactMessageDetail_DateStart'],
            $object['WebContactMessageDetail_Package'],
            $object['WebContactMessageDetail_Status'],
            $object['Id_WebContactMessage'],
            0
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_WebContactMessageDetail'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return array_merge(
            WebContactMessageMother::tablesToClear(),
            [TableCreation::WEB_CONTACT_MESSAGE_DETAIL]
        );
    }
}
