<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Illuminate\Support\Facades\DB;

class TypeEquipmentMother {
    
    public static function build1($id = 1) {
        $faker = \Faker\Factory::create();
        return [
            'Id_TypeEquipment' => $id,
            'TypeEquipment_Name' => $faker->text(rand(5, 250)),
            'TypeEquipment_Abrv' => Util::generateString(4),
            'TypeEquipment_Status' => $faker->randomElement([1, 2])
        ];
    }

    public static function push1($id = 1) {
        return self::push(self::build1($id));
    }

    private static function push($object) {
        $response = DB::select("CALL `sp_type_equipment_insert` (?,?,?)", [
            $object['TypeEquipment_Name'],
            $object['TypeEquipment_Abrv'],
            $object['TypeEquipment_Status']
        ]);
        $object['Id_TypeEquipment'] = $response[0]->Response_Id;
        return $object;
    }

}