<?php

namespace App\DBRealTestSupport;

use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaMediaStatus;
use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaStatus;
use Faker\Factory;
use Illuminate\Support\Facades\DB;

class GroupPassengerMediaMother
{

    public const BOOKING_TOUR_PASSENGER = 1;
    public const PASSENGER = 2;

    public static function build1($idGroupPassenger, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_GroupPassengerMedia' => $id,
            'GroupPassengerMedia_Path' => $faker->text(rand(5, 250)),
            'GroupPassengerMedia_Path_Thumb' => $faker->text(rand(5, 250)),
            'GroupPassengerMedia_Extension' => $faker->text(rand(5, 11)),
            'GroupPassengerMedia_Size' => rand(1, 100000),
            'GroupPassengerMedia_Type' => $faker->randomElement([1, 2]),
            'GroupPassengerMedia_Error' => $faker->text(rand(5, 1000)),
            'GroupPassengerMedia_Status' => $faker->randomElement([1, 2]),
            'Id_GroupPassenger' => $idGroupPassenger
        ];
    }

    public static function push1($idGroupPassenger, $id = 1)
    {
        return self::push(self::build1($idGroupPassenger, $id));
    }

    private static function push($object)
    {
        DB::select(
            "INSERT INTO `t_group_passenger_media` (?,?,?,?,?,?,?)",
            [
                $object['GroupPassengerMedia_Path'],
                $object['GroupPassengerMedia_Path_Thumb'],
                $object['GroupPassengerMedia_Extension'],
                $object['GroupPassengerMedia_Size'],
                $object['GroupPassengerMedia_Type'],
                $object['GroupPassengerMedia_Error'],
                $object['GroupPassengerMedia_Status'],
                $object['Id_GroupPassenger'],
            ]
        );
        $object['Id_GroupPassengerMedia'] = DB::select('SELECT LAST_INSERT_ID() as `Id`')[0]->Id;
        return $object;
    }

    public static function tablesToClear()
    {
        return [
            TableCreation::GROUP_PASSENGER_MEDIA,
            ...GroupPassengerMother::tablesToClear(),
        ];
    }
}
